<?php
	// Loads child theme textdomain
	load_child_theme_textdomain( CURRENT_THEME, CHILD_DIR . '/languages' );

	add_filter( 'cherry_stickmenu_selector', 'cherry_change_selector' );
	function cherry_change_selector($selector) {
		$selector = 'header .nav-wrap';
		return $selector;
	}

	// google_api_map
	if ( !function_exists('google_map_api_shortcode') ) {
		function google_map_api_shortcode( $atts, $content = null ) {
			extract(shortcode_atts(array(
					'lat_value'      => '41.850033'
				,	'lng_value'      => '-87.6500523'
				,	'zoom_value'     => '8'
				,	'zoom_wheel'     => 'no'
				,	'custom_class'  => ''
			), $atts));

			$random_id        = rand();
			$lat_value        = floatval( $lat_value );
			$lng_value        = floatval( $lng_value );
			$zoom_value       = intval( $zoom_value );
			$zoom_wheel       = $zoom_wheel=='yes' ? 'true' : 'false';

			$output = '<div class="google-map-api '.$custom_class.'">';
			$output .= '<div id="map-canvas-'.$random_id.'" class="gmap"></div>';
			if($content) {
				$output .= '<div class="container absolute-block"><div class="row"><div class="span12">'.do_shortcode($content).'</div></div></div>';
			}
			$output .= '</div>';
			$output .= '<script type="text/javascript">
					google_api_map_init_'.$random_id.'();
					function google_api_map_init_'.$random_id.'(){
						var map;
						var coordData = new google.maps.LatLng(parseFloat('.$lat_value.'), parseFloat('.$lng_value.'));

						function initialize() {
							var mapOptions = {
								zoom: '.$zoom_value.',
								center: coordData,';
								if(strpos ($custom_class, "with-overlay") !== false) {
									$output .= 'draggable: false,
									disableDefaultUI: true,';
								}
								$output .= 'scrollwheel: '.$zoom_wheel.',
								styles: [{"featureType":"road","elementType":"geometry","stylers":[{"color":"#b1ab85"}]},{"featureType":"water","elementType":"geometry","stylers":[{"color":"#8cc0c3"}]},{"featureType":"poi.park","elementType":"geometry","stylers":[{"color":"#cde6cf"}]},{"featureType":"landscape.man_made","elementType":"geometry","stylers":[{"color":"#efede8"}]}]
							}
							var map = new google.maps.Map(document.getElementById("map-canvas-'.$random_id.'"), mapOptions);
						}
						google.maps.event.addDomListener(window, "load", initialize);
					}
					
			</script>';
			return $output;
		}
		add_shortcode('google_map_api', 'google_map_api_shortcode');
	}

	// Loads custom scripts.
	require_once(CHILD_DIR . '/parallax-slider/php/parallax-slider-video-meta.php');
	require_once( 'custom-js.php' );
	require_once( 'shortcodes/mini-posts-list.php' );
	require_once( 'shortcodes/posts-grid.php' );
?>